#if 0

#define		cDriveNum			1;		//	{ internal drive }
#define		cSectorSize			512;
#define		cSectorsPerTrack	9;		//	{ or 18, for HD disks }
#define		cSides				2;  	//	{ double-sided only, for now }

char		*gSectBuffer;

void	BailOut(char *message, OSErr err)
{
	AlertID(message, err);
	err = Eject(NULL, cDriveNum);
	ExitToShell();
}

void	Initialize(void)
{
	gSectBuffer = TrackNewPtr("floppy sector", cSectorSize);
	
	if (gSectBuffer == NULL) {
		BailOut("not enough memory", MemError());
	}
}

Boolean		FloppyInserted(short driveNumS)
{
	Str255			volumeName;
	short			vRefNum;
	long			freeBytes;
	OSErr			err = noErr;
	EventRecord		evt;
	Boolean			endRepeatB;

	err := Eject(nil, driveNumS);  { make clear something will happen to the driveNumS }
	
	do {
		CopyCStringToPascal("?", volumeName);
		
		err = GetVinfo(driveNumS, volumeName, vRefnum, freeBytes);
		
		if (err == nsvErr) {	//  { no such volume }
			SysBeep(1);
			
			OKCancelDialog()
			Writeln('insert floppy in the internal drive');
			Writeln('(if you have a SuperDrive , even an MS - DOS one !) ');
			Writeln('or click the mouse to quit');
			Writeln;
			endRepeatB := false;
			repeat
				if GetNextEvent(everyEvent, evt) then
					endRepeatB := (evt.what in [mouseDown, diskEvt]);
			until endRepeatB;
			if evt.what = mouseDown then
				begin
					err := Eject(nil, driveNumS);  { for convenience, just in case }
					ExitToShell;
				end
			else
				err := BitShift(evt.message, -16);  { is currently "extFSErr" for MS-DOS floppies }
		}
	until err <> nsvErr;

	return (err != nsvErr);	//	  { should be more careful here! }
}

	procedure ReadSector (t, f, n: Integer; p: Ptr);
{ read sector <n> on face <f> of track <t> into buffer <p> }
		var
			paramBlock: ParamBlockRec;
			trackSize: Longint;
			err: OsErr;
	begin
		trackSize := cSectorSize * cSectorsPerTrack;
		with paramBlock do
			begin
				ioCompletion := nil;
				ioVRefnum := cDriveNum;
				ioRefnum := -5;
				ioBuffer := p;
				ioReqCount := cSectorSize;
				ioPosMode := fsFromStart;
				ioPosOffset := trackSize * (cSides * t + f) + cSectorSize * n;
			end;
		err := PBReadSync(@paramBlock);
		if err <> noErr then
			BailOut('PBRead returns ', err);
	end;

	procedure DisplaySector (t, f, n: Integer; p: Ptr);
		var
			i: Integer;
			c: Char;
			p0: Ptr;

		function Hex (b: SignedByte): Str255;
			var
				hx: string[16];
				s: str255;
		begin
			s := 'xx';
			hx := '0123456789ABCDEF';
			s[1] := hx[1 + BitAnd(BitShift(b, -4), $0F)];
			s[2] := hx[1 + BitAnd(b, $0F)];
			Hex := s;
		end;

	begin
		p0 := p;
		Writeln('Track ', t : 2, '  -- face ', f : 1, ' -- sector ', n : 2, ' (first 16 bytes):');
		for i := 0 to 15 do
			begin
				Write(Hex(p^), ' ');
				p := Ptr(Longint(p) + 1);
			end;
		Write('   ');
		p := p0;
		for i := 0 to 15 do
			begin
				c := chr(p^);
				if ord(c) > 31 then
					Write(c)
				else
					Write('.');
				p := Ptr(Longint(p) + 1);
			end;
		Writeln;
		Writeln;
	end;

	procedure DemoTime;
		var
			track: 0..79;
			side: 0..1;
			sector: 0..8;  { cSectorsPerTrack - 1 }
	begin
		track := 0;
		side := 0;
		sector := 0;
		ReadSector(track, side, sector, gSectBuffer);
		DisplaySector(track, side, sector, gSectBuffer);
		BailOut('That''s all folks', 0);
	end;

begin
	Initialize;
	if FloppyInserted(cDriveNum) then
		DemoTime;
end.

#endif